/*---------------------------------------------------------------------------*\

    FILE....: GENERIC.H
    TYPE....: C Functions
    AUTHOR..: David Rowe
    DATE....: 12/9/99

    This header file defines the interfaces of the generic functions
    that are used to access Operating System specific functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __GENERIC__
#define __GENERIC__

#ifdef WIN32
#define	WINAPI	__stdcall
#else
#define	WINAPI
#endif
#ifdef __FreeBSD__
#include <sys/types.h>
#endif

#include "contypes.h"
#include "vpbapi.h"

// Critcal section functions

typedef struct {void *v; } GENERIC_CRITICAL_SECTION;	

void WINAPI GenericInitializeCriticalSection(GENERIC_CRITICAL_SECTION *cs);
void WINAPI GenericDeleteCriticalSection(GENERIC_CRITICAL_SECTION *cs);
void WINAPI GenericEnterCriticalSection(GENERIC_CRITICAL_SECTION *cs);
void WINAPI GenericLeaveCriticalSection(GENERIC_CRITICAL_SECTION *cs);

int GenericDeviceIoControl(
	void	      *hndFile,	      // Handle to device
	long	      IoctlCode,      // IO Control code for Read
	void	      *InBuffer,      // Buffer to driver.
	long	      InBufferSize,      
	void	      *OutBuffer,     // Buffer from driver
	long	      OutBufferSize,     
	unsigned long *BytesReturned, // no. bytes returned from driver
	void	      *Overlapped     
);

void *GenericOpenMk0Driver();
void *GenericOpenMk1Driver();
int GenericCloseHandle(void *hndFile);

unsigned long GenerictimeGetTime();

int GenericGetCardType();

int GenericGetNumCards(int vpb_model);

// Get OS Type

#define GET_OS_WINDOWS_95	0
#define GET_OS_WINDOWS_NT	1
#define GET_OS_LINUX		2
#define GET_OS_USER		3
#define	GET_OS_FAIL	       -1

int GenericGetOS();

void GenericSleep(unsigned int ms);
void WINAPI Generic_beginthread(void(*func)(void*), int stack, void *data);
void WINAPI Generic_endthread();
void GenericSetThreadPriorityHigh();
void GenericSetThreadPriorityNormal();

// Linux Device driver (ISA)
int Generic_add_board(int fd, void *data);
int Generic_remove_board(int fd, void *data);
int Generic_block_write(int fd, void *data);
int Generic_block_read(int fd, void *data);
int Generic_open();
int Generic_close(int fd);

// Linux Driver driver (PCI)
int Generic_pci_dsp_reset(int fd, USHORT board);
int Generic_pci_dsp_run(int fd, USHORT board);
int Generic_pci_block_read(int fd, 
			   unsigned short board, 
			   unsigned short addr, 
			   unsigned short length, 
			   unsigned short *buf);
int Generic_pci_block_write(int fd,
			   unsigned short board, 
			   unsigned short addr, 
			   unsigned short length, 
			   unsigned short *buf);
int Generic_pci_block_eeread(int fd,
			   unsigned short board, 
			   unsigned short addr, 
			   unsigned short length, 
			   unsigned short *buf);

#endif
